# ealis ver.3.0   compactHTML plugin
#  --  by K.Kan'o (kano@feena.jp) , 02/05/14
# ---  erialarts : http://kano.feena.jp/erial/
# (EUC )

require './ealis_cfg.cgi';
require 'jcode.pl';

package main;
	use vars qw[%FORM %COOKIE];

	&form_decode;

	my($logobj) = new LogReader;

	my($linechars) = $ENV{HTTP_X_UP_DEVCAP_SCREENCHARS};
	if ($linechars > 2) {
		$linechars -= 2;
	} else {
		$linechars = 14;
	}
	local($hr) = '<LINE>&nbsp;' . ('-' x $linechars) . '&nbsp;';

	my($hdmldata) = new HdmlOut;

	if(defined($FORM{thr})){
		$hdmldata->header;
		$hdmldata->{q} .= &ThreadMode::main($logobj);
		$hdmldata->{q} .= &LogPager($logobj,'thr');
	}elsif($FORM{pick}){
		$hdmldata->header;
		$hdmldata->{q} .= &PrintArticle::main($logobj,$FORM{pick});

	}elsif(defined($FORM{lap})){
		$hdmldata->header;
		my($lapse) = new LapseMode $logobj;
		$hdmldata->{q} .= $lapse->show($logobj);
		$hdmldata->{q} .= &LogPager($logobj,'lap');

	}elsif(defined($FORM{new})){
		$hdmldata->header;
		$hdmldata->{q} .= &PostForms::oya;
	}elsif($FORM{res}){
		$hdmldata->header;
		$hdmldata->{q} .= &PostForms::res($FORM{res});

	}else{
		$hdmldata->header;
		$hdmldata->{q} .= &print_top($logobj);
	}

	$hdmldata->{q} .= &print_navi if($ENV{QUERY_STRING});

	$hdmldata->out();

exit;


sub print_top
{
	return
	qq!<DISPLAY TITLE="$ini::title"><WRAP><B>$ini::h1s</B>!
	. '<WRAP>' . shift()->{lastwrite}
	. qq!<WRAP><A TASK=GOSUB DEST="$ini::plug_chtm?thr" ACCESSKEY=7>Thread</A>!
	. qq!<WRAP><A TASK=GOSUB DEST="$ini::plug_chtm?lap" ACCESSKEY=8>Lapse</A>!
	. qq!<WRAP><A TASK=GOSUB DEST="$ini::plug_chtm?new" ACCESSKEY=9></A>!
	. '</DISPLAY>';
}
sub print_navi
{
	return qq!$hr<A TASK=GO DEST="?" ACCESSKEY=0>Top</A></DISPLAY>!;
}

sub LogPager
{
	my($logobj,$arg) = @_;

	my $current_tab = int( $main::FORM{st} / $main::FORM{show} ) + 1;
	my $tab = (($current_tab >= 4) ? ($current_tab - 2) : 1);		# ϥNo.

	my($tmp,$gopage);
	for(1 .. 5){
		if($tab == $current_tab){
			$tmp .= "$tab ";
		}else{
			$gopage = $main::FORM{show} * ( $tab - 1 );		# ܤε
			($gopage < $logobj->{oya_num}) || last;			# ͭƵ¿
			$tmp .= sprintf '<A TASK=GOSUB DEST="%s?%s;st=%d;show=%d">%d</A><BR>',
							$ini::plug_chtm, $arg,$gopage,$main::FORM{show},$tab;
		}
		$tab++;
	}

	return "<BR>$tmp";
}

## 
sub form_decode
{
	# Deny IP Check
	foreach(@ini::deniedaddrs){
		if(index($ENV{REMOTE_ADDR}, $_ ) == 0 && length($_) > 4 ){
			print "Status: 204";
			exit;
		}
	}

	# form decode
	my($name, $value);
	foreach ( split(/[&;]/,$ENV{QUERY_STRING}) ) {
		($name, $value) = split(/=/, $_,2);
		$value =~ tr/+/ /;
		$FORM{$name} = $value || '';
	}

	# set default
	$FORM{show}  ||= 4;
	$FORM{st} ||= 0;
}


sub error
{
	&out_buffer( sprintf '<html><body><h1>顼</h1><p>%s</p>',shift);
	exit;
}

###---------
package HdmlOut;
sub new
{
	bless { q => '' };
}
sub header
{
	my($obj) = @_;

	$obj->{q} .= '<HDML VERSION="3.0" PUBLIC="TRUE" MARKABLE="TRUE" TTL=0>';
}
sub out
{
	my($obj) = @_;
	$obj->{q} .= '</HDML>';

	print "Content-type: text/x-hdml; charset=Shift_JIS\n";

	&jcode::z2h_euc(\$obj->{q});
	&jcode::tr(\$obj->{q}, '--ڣ-','0-9A-Za-z');
	&jcode::tr(\$obj->{q}, 'ɡʡˡᡰáСѡܡ',' @!"#$%()=^|{}:;+*?_/-');

	&jcode::euc2sjis(\$obj->{q});

	printf "Content-length: %d\n\n" , length($obj->{q});
	print $obj->{q};
}

###---------
package PostForms;
sub oya
{
	return
	  q!<NODISPLAY NAME="__card1"><ACTION TYPE="ACCEPT" TASK="GOSUB" VARS="NAME=&SUBJ=&COMMENT=" DEST="#__card2"></NODISPLAY>!
	. q!<ENTRY KEY="NAME" FORMAT="M*M" NAME="__card3"><ACTION TYPE="ACCEPT" TASK="GO" DEST="#__card2">Name</ENTRY>!
	. q!<ENTRY KEY="SUBJ" FORMAT="M*M" NAME="__card4"><ACTION TYPE="ACCEPT" TASK="GO" DEST="#__card2">Title</ENTRY>!
	. q!<ENTRY KEY="COMMENT" FORMAT="MM*M" NAME="__card5"><ACTION TYPE="ACCEPT" TASK="GO" DEST="#__card2">ʸ</ENTRY>!
	. q!<DISPLAY NAME="__card2"><ACTION TYPE=SOFT1 LABEL="" TASK=RETURN>!
	. q!<WRAP><B></B>!
	. q!<WRAP>Name<A TASK="GO" LABEL="Խ" DEST="#__card3">$(NAME)</A>!
	. q!<WRAP>Title<A TASK="GO" LABEL="Խ" DEST="#__card4">$(SUBJ)</A>!
	. q!<WRAP>ʸ<A TASK="GO" LABEL="Խ" DEST="#__card5">$(COMMENT)</A>!
	.qq!<BR><BR><A TASK="GO" LABEL="" DEST="$ini::scriptwri" METHOD="POST"!
	. q! POSTDATA="name=$(NAME:esc)&subj=$(SUBJ:esc)&comment=$(COMMENT:esc)&color=#000000!
	.qq!&icon=$ini::mobileicon&chtm=1" ACCESSKEY=1>  </A>!;
}

sub res
{
	my($pick) = @_;

	return 
	  q!<NODISPLAY NAME="__card1"><ACTION TYPE="ACCEPT" TASK="GOSUB" VARS="NAME=&COMMENT=" DEST="#__card2"></NODISPLAY>!
	. q!<ENTRY KEY="NAME" FORMAT="M*M" NAME="__card3"><ACTION TYPE="ACCEPT" TASK="GO" DEST="#__card2">Name</ENTRY>!
	. q!<ENTRY KEY="COMMENT" FORMAT="MM*M" NAME="__card4"><ACTION TYPE="ACCEPT" TASK="GO" DEST="#__card2">ʸ</ENTRY>!
	. q!<DISPLAY NAME="__card2"><ACTION TYPE=SOFT1 LABEL="" TASK=RETURN>!
	.qq!<WRAP><B>ֿ #$pick</B>!
	. q!<WRAP>Name<A TASK="GO" LABEL="Խ" DEST="#__card3">$(NAME)</A>!
	. q!<WRAP>ʸ<A TASK="GO" LABEL="Խ" DEST="#__card4">$(COMMENT)</A>!
	.qq!<BR><BR><A TASK="GO" LABEL="ֿ" DEST="$ini::scriptwri" METHOD="POST"!
	. q! POSTDATA="name=$(NAME:esc)&subj=$(SUBJ:esc)&comment=$(COMMENT:esc)&color=#000000!
	.qq!&icon=$ini::mobileicon&chtm=1&resno=$pick" ACCESSKEY=1> ֿ </A>!;
}


###---------
package PrintArticle;
sub main
{
	my($logobj,$pick) = @_;

	my($tmp,$line,$seeflag);
	while($line = $logobj->lread()){
		(index($line, "\t$pick\t") != 4 ) && next;
		$oyaflag = 0;
		if(substr($line,0,1) eq '*'){ $oyaflag = 1;}
		else{ ++$rescnt; }

		$tmp .= &lettering($line,$oyaflag,$rescnt);
	}
	return $tmp . qq!<BR><A TASK=GOSUB DEST="$ini::plug_chtm?res=$pick" ACCESSKEY=1>ֿ</A>!;
}
sub lettering
{
	my($ATC);
	($ATC{seri},$ATC{number},$ATC{date},$ATC{name},$ATC{subj},$ATC{comment},$ATC{color},$ATC{email},
		$ATC{url},$ATC{icon},$ATC{edt},$ATC{ipaddr},$ATC{pwd})
			= split("\t",shift());

	if( shift() ){
		return  qq!<DISPLAY TITLE="$ini::title #$FORM{pick}"><ACTION TYPE=SOFT1 LABEL="" TASK=RETURN><WRAP><B>$ATC{subj} : $ATC{name}</B>!
				 . qq!<WRAP>$ATC{comment}!;
	}else{
		return qq!$hr<WRAP>$ATC{name}&gt;&gt;$ATC{comment}!;
	}
}

###---------
package ThreadMode;
sub main
{
	my($logobj) = @_;

	my($tmp) =  qq!<DISPLAY TITLE="$ini::title thr."><ACTION TYPE=SOFT1 LABEL="" TASK=RETURN><WRAP><B></B>!;

	my($line,$i,$ankor,$parent,$flag,$rescnt);
	while($line = $logobj->lread()){
		if(substr($line,0,1) eq '*'){
			if($main::FORM{st} < $i){
				$ankor++;
				if($ankor > $main::FORM{show}){ $flag = 1; last; }
				$tmp .= &show(\$parent,$rescnt);
				$rescnt = 0;
			}
			$i++;
			$parent = $line;
		}else{
			($main::FORM{st} < $i) && $rescnt++;
		}
	}
	close(IN);
	($flag) || ( $tmp .= &show(\$parent,$rescnt));

	return $tmp;
}
sub show
{
	my($seri,$number,$date,$name,$subj,$comment,$color,$email,$url,$icon,$edt,$ipaddr)
		 = split("\t",${shift()});
	my($rescnt) = shift;

	($subj) ||= ((substr($seri,0,1) eq '*') ? '(̵)' : ' (res) ');

	return sprintf '<WRAP><A TASK=GOSUB DEST="%s?pick=%d">%d</A>.%d:%s<BR>%s<BR>',
							$ini::plug_chtm, $number,$number,$rescnt,$name,$subj;
}


###---------
package LapseMode;
sub new
{
	shift;
	my($logobj) = shift;

	my($p) = {};
	$logobj->{oya_num} = 0;

	# ꥢϰϤhash
	my($key);
	for(0 .. ($main::FORM{show} -1)){
		$key = $logobj->{seri_last} - $main::FORM{st} - $_ ;
		$key += 1000 if($key < 0);
		($key >= 0) || last;
		$p->{ sprintf '%03d',$key } = '';
	}

	# ˹äɤ
	my($seri,$line);
	my($showcnt) = $main::FORM{show};
	while($line = $logobj->lread() ){
		$logobj->{oya_num}++;				# pagerɬ

		($showcnt > 0) || next;

		$seri = substr($line,1,3);
		if( defined($p->{$seri}) ){
			$p->{$seri} = $line;
			--$showcnt;
		}
	}

	bless $p;
}
sub show
{
	my($obj,$logobj) = @_;

	my($buf) = qq!<DISPLAY TITLE="$ini::title lap."><ACTION TYPE=SOFT1 LABEL="" TASK=RETURN><WRAP><B>lapse</B>!;

	my($key);
	foreach $key (	map { $_->[0] }
					sort { $b->[1] <=> $a->[1] }
					map { [$_, (($_ > $logobj->{seri_last}) ? ($_ -1000) : $_ )] }
				keys %{$obj} ) {

		($obj->{$key}) || next;
		my($seri,$number,$date,$name,$subj,$comment,$color,$email,$url,$icon,$edt,$ipaddr)
			 = split("\t",$obj->{$key});

		($subj) ||= '---' if(substr($seri,0,1) eq '*');

		$buf .=
		 "<WRAP><A TASK=GOSUB DEST=\"?pick=$number\">$number</A>:$subj"
		. "<BR>$name ($date)<BR>"
		. qq!$comment<BR>!;

	}

	return $buf;
}

###---------
package LogReader;
sub new
{
	my($p) = {};

	open(IN,"$ini::logfile") || die "ե$ini::logfileפޤ";
	$_ = scalar(<IN>);
	chomp($_);

	split(/,/,$_,5);
	(shift eq '[ealis3]') || die 'ealis 裳ΥǤϤޤ';
	($p->{oya_num},$p->{seri_last},$p->{lastwrite}) = @_[0,2,3];

	bless $p;
}
sub lread
{
	return scalar(<IN>);
}
sub DESTROY
{
	close(IN);
}

BEGIN{
	$SIG{'__DIE__'} = sub{
	print "Content-Language: ja\n";
	print "Content-type: text/plain; charset=euc-jp\n\n";
	print <<"EOD";
<h2>ealis̿Ūƥ२顼ȯޤ</h2>
<p><strong>$_[0]</strong></p>
<p><a href="$ini::scriptmain?">Refresh</a></p>

<pre>
// perl env
	perl: $]  (at $^X )
	OS  : $^O
	file: $0
// cgi env
	CONTENT_LENGTH: $ENV{'CONTENT_LENGTH'}
	QUERY_STRING  : $ENV{'QUERY_STRING'}
	REQUEST_METHOD: $ENV{'REQUEST_METHOD'}

	HTTP_PATH  : $ENV{'HTTP_HOST'} $ENV{'SCRIPT_NAME'}
	SERVER_SOFTWARE : $ENV{'SERVER_SOFTWARE'}  -on-  $ENV{'OS'}
// end
</pre>
EOD
	exit;}
}
